#!/bin/bash
export datasets1="Cora CiteSeer PubMed cs wikics"
export datasets2="physics OGBN-Arxiv"
export missing_rates="0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=1

# Products - uniform
# python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.1 --embedder MLP --filling_method zero --n_runs 3 --gpu ${gpu}
# python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.2 --embedder MLP --filling_method zero --n_runs 3 --gpu ${gpu}
# python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.3 --embedder MLP --filling_method zero --n_runs 3 --gpu ${gpu}

python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.0 --embedder Correct_Smooth --n_runs 3 --gpu ${gpu}
python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.1 --embedder Correct_Smooth --n_runs 3 --gpu ${gpu}
python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.2 --embedder Correct_Smooth --n_runs 3 --gpu ${gpu}

python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.7 --embedder GNN --filling_method zero --gnn SAGE --n_runs 3 --gpu ${gpu}
python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.0 --embedder GNN --filling_method neighborhood_mean --gnn SAGE --n_runs 3 --gpu ${gpu}
python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.1 --embedder GNN --filling_method neighborhood_mean --gnn SAGE --n_runs 3 --gpu ${gpu}
python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.2 --embedder GNN --filling_method neighborhood_mean --gnn SAGE --n_runs 3 --gpu ${gpu}
python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.7 --embedder GNN --filling_method neighborhood_mean --gnn SAGE --n_runs 3 --gpu ${gpu}
python main.py --dataset OGBN-Products --missing_type uniform --missing_rate 0.7 --embedder GNN --filling_method fp --gnn SAGE --n_runs 3 --gpu ${gpu}
